
do $$
begin
	if exists (select 1 from pg_type where typname = 'rs_desc_dados_produto') then
		drop type public.rs_desc_dados_produto cascade;
	end if;
end$$;

CREATE TYPE rs_desc_dados_produto as
     (
				vlr_tabela double precision,
				perc_desc double precision,
				cd_prod integer
	 );


do $$
begin
	if exists (select 1 from pg_type where typname = 'rs_temp_dados_produto') then
		drop type public.rs_temp_dados_produto cascade;
	end if;
end$$;

			
	CREATE TYPE rs_temp_dados_produto as
	(
	cd_prod integer,
	qt_it integer
    );
     
              
     
	 CREATE OR REPLACE FUNCTION public.ufd_get_desc_parceiro(integer, integer, integer)
	 RETURNS void
	 LANGUAGE plpgsql
	 COST 10
	 AS $function$			
				 /*  
					 EMPRESA  : LINX_ITEC
					 FUNCAO   : UFD_GET_DESC_PARCEIRO
					 OBJETIVO : CALCULAR DESCONTOS PARCEIROS 
					 AUTOR    : RAINNER GUIMARÃES
					 CRIACAO  : 07/2021 */						
				DECLARE 
				DESC_PRODUTOS 	RS_DESC_DADOS_PRODUTO;
				DADOS_PRODUTO 	RS_TEMP_DADOS_PRODUTO;
				INT_CD_EMP 		ALIAS FOR $1;
				INT_CD_FILIAL 	ALIAS FOR $2;
				INT_CD_VD 		ALIAS FOR $3;
				PERCEN_DESC 	DOUBLE PRECISION;
				VALOR_TABELA 	DOUBLE PRECISION;
				
				BEGIN
				
					BEGIN
						CREATE TEMPORARY TABLE temp_dados_produto
						(	
							cd_prod 		integer,
							qt_it 			integer		
						);
						EXCEPTION WHEN OTHERS THEN
						TRUNCATE TABLE temp_dados_produto; -- TRUNCA A TABELA SE ELA JÁ EXISTIR NA CORRENTE SESSÃO.
					END;
				    
				    BEGIN
						CREATE TEMPORARY TABLE desc_dados_produto
						(	
							vlr_tabela double precision,
							perc_desc  double precision,
							cd_prod  integer
						);
						EXCEPTION WHEN OTHERS THEN
						TRUNCATE TABLE desc_dados_produto; -- TRUNCA A TABELA SE ELA JÁ EXISTIR NA CORRENTE SESSÃO.
					END;
				
						INSERT INTO temp_dados_produto    
											SELECT it.cd_prod 	as cd_prod ,
												   it.qt_it 	as qt_it
											  FROM pdv_vd_it it 
											 WHERE it.cd_emp = int_cd_emp 
											   AND it.cd_filial = int_cd_filial 
											   AND it.cd_vd     = int_cd_vd 
											   AND it.st_it     = 1
											   AND it.perc_desc_verba <= 0;	
				
					
						FOR dados_produto IN SELECT cd_prod, qt_it  FROM temp_dados_produto
						
						LOOP INSERT INTO desc_dados_produto    
													SELECT
														vlr_tabela,
														perc_desc,
														cd_prod
													FROM
														p_est_prod_descontos(int_cd_emp,int_cd_filial,dados_produto.cd_prod,0,'0',1,1,dados_produto.qt_it,3,0,0,0,0,1);
						
						END LOOP;
									
						FOR desc_produtos IN SELECT vlr_tabela,perc_desc,cd_prod  FROM desc_dados_produto
						
							LOOP valor_tabela = desc_produtos.vlr_tabela;
								 percen_desc =  desc_produtos.perc_desc;
						
										UPDATE pdv_vd_it  
										SET vlr_desc_it = SubQuery.vlr_desc_it,
										    tipo_desconto = 31,
										    tx_desc = SubQuery.tx_desc,
										    vlr_tot_it = SubQuery.vlr_tot_it,
										    vlr_liq_it = (SubQuery.vlr_tot_it - SubQuery.vlr_desc_it) 		   			    			
							            FROM (SELECT  (it.qt_it * ((valor_tabela * percen_desc) / 100)) as vlr_desc_it,
								                         desc_produtos.perc_desc as tx_desc,
								                         (it.qt_it * it.vlr_it) as vlr_tot_it,							                         				                         
								                          it.cd_it 	as cod_item	                         
														FROM pdv_vd_it it 
														WHERE it.cd_emp = int_cd_emp 
														AND it.cd_filial = int_cd_filial 
														AND it.cd_vd = int_cd_vd 
														AND it.cd_prod = desc_produtos.cd_prod
														AND it.st_it = 1) as SubQuery
													
										 WHERE cd_emp = int_cd_emp 
										 AND   cd_filial = int_cd_filial 
										 AND   cd_vd = int_cd_vd 
										 AND   cd_prod = desc_produtos.cd_prod
										 AND   cd_it = SubQuery.cod_item
										 AND   st_it = 1;		
						
						END LOOP;		
				END;
	$function$
	;